; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
; @author: CABOS Matthieu
; @date: 30/04/2018

#define MyAppName "PyMoDAQ"
#define MyAppVersion "1.0"
#define MyAppPublisher "CEMES-CNRS"
#define MyAppURL "https://github.com/PyMoDAQ"
#define MyAppIco "icon.ico"

[Setup]
; On retrouve les informations essentielles concernant l'application.
; Il s'agit des metadatas du setup et des paramtres d'initialisation.
; Un setup est autentifi par un identifiant unique, renouvel  chaque nouvelle cration.

; identifiant du setup
AppId={{C2DB07D6-2158-4971-B04D-A02F0F603D74} 
; nom de l'application   
AppName={#MyAppName}
; version de l'application
AppVersion={#MyAppVersion}
; nom du distributeur
AppPublisher={#MyAppPublisher}
; adresse web du distributeur
AppPublisherURL={#MyAppURL}
; adresse web du service de support
AppSupportURL={#MyAppURL}
; adresse web du service d'update du logiciel
AppUpdatesURL={#MyAppURL}
; directoire par default
DefaultDirName={pf}\{#MyAppName}
; nom de groupe par default
DefaultGroupName={#MyAppName}
LicenseFile="C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\LICENSE"
; options
AllowNoIcons=yes
InfoBeforeFile=C:\Users\flim-users\Documents\Tests install\final\PyMoDAQ\README-install guide.txt
InfoAfterFile=C:\Users\flim-users\Documents\Tests install\final\PyMoDAQ\README.txt
OutputDir=C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\
OutputBaseFilename=Setup
Compression=lzma
SolidCompression=yes

[Languages]
; options de langues du setup
Name: "english"; MessagesFile: "compiler:Default.isl"

; Definir deux type d'installation : Full et Custom  
[Types]
; installation complete sans selection des modules
Name: "full"; Description: "Full installation";
; installation personnalise avec choix des modules  installer
Name: "custom"; Description: "Custom installation";

; On lie aux type les composantes associees
[Components]
; Balise d'installation complte
Name: "full"; Description: "Full Installation"; Types: full
; Balise d'installation personnalise
Name: "custom"; Description: "Custom Installation"; Types: custom

; Definition des choix de modules selon la composante custom (apparaissent sous forme d'une checkbox dans le setup)
[Tasks]
; Balise d'installation du DAQ_Metheor, la balise est lie au Component custom
Name: "DAQ_Metheor"; Description: "DAQ Metheor module installer"; GroupDescription: "Modules:"; Components: custom; 
; Balise d'installation du DAQ_Scan comme pre des suivants (necessitent les modules fils pour fonctionner)
; La balise est lie au Component custom
Name: "DAQ_Scan"; Description: "DAQ Scan module installer"; GroupDescription: "Modules:"; Components: custom; 
; Balise d'installation du DAQ_Analysis comme fils de DAQ_Scan, la balise est lie au Component custom
Name: "DAQ_Scan\DAQ_Analysis"; Description: "DAQ Analysis module installer"; GroupDescription: "Modules:"; Components: custom;  
; Balise d'installation du DAQ_Measurement comme fils de DAQ_Scan, la balise est lie au Component custom
Name: "DAQ_Scan\DAQ_Measurement"; Description: "DAQ Measurement module installer"; GroupDescription: "Modules:"; Components: custom; 
; Balise d'installation du DAQ_Move comme fils de DAQ_Scan, la balise est lie au Component custom
Name: "DAQ_Scan\DAQ_Move"; Description: "DAQ Move module installer"; GroupDescription: "Modules:"; Components: custom; 
; Balise d'installation du DAQ_Viewer comme fils de DAQ_Scan, la balise est lie au Component custom
Name: "DAQ_Scan\DAQ_Viewer"; Description: "DAQ Viewer module installer"; GroupDescription: "Modules:"; Components: custom; 

[Files]
;Installation des fichiers communs  tout les profils d'installation
; Il faut tre vigilent  bien reconstruire la mme arborescence d'application grace aux champs DestDir 
; La specification C:\path\dossier\* associ aux flags recursesubdirs et createallsubdirs copie l'ensemble des 
; sous-repertoires
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\.spyproject\*"; DestDir: "{app}\.spyproject"; Flags: ignoreversion recursesubdirs createallsubdirs;
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\__pycache__\*"; DestDir: "{app}\__pycache__"; Flags: ignoreversion recursesubdirs createallsubdirs;
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\Documentation\*"; DestDir: "{app}\Documentation"; Flags: ignoreversion recursesubdirs createallsubdirs;
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\Libraries_packages\*"; DestDir: "{app}\Libraries_packages"; Flags: ignoreversion recursesubdirs createallsubdirs;
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\Manuals\*"; DestDir: "{app}\Manuals"; Flags: ignoreversion recursesubdirs createallsubdirs;
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\QtDesigner_Ressources\*"; DestDir: "{app}\QtDesigner_Ressources"; Flags: ignoreversion recursesubdirs createallsubdirs;
; La specification C:\path\fichier copie uniquement le fichier correspondant
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\__init__.py"; DestDir: "{app}";
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\icon.ico"; DestDir: "{app}";
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\LICENSE"; DestDir: "{app}";
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\README.md"; DestDir: "{app}";
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\README.txt"; DestDir: "{app}";
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\README-install guide.txt"; DestDir: "{app}"; 
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\welcome.html"; DestDir: "{app}";

;Full installation bundle
; Ici le repertoire spcifi n'est copi que si le profil d'installation correspond  la Balise full
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: full 

;Custom installation files (depending on tasks section)
; De la mme manire les repertoires ci-dessous ne sont copie que si le profil d'installation correspond  la Balise custom
; et si de plus le tasks correspondant a t coch (dans ce cas la balise tasks sera active lors de l'execution du setup).
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\DAQ_Analysis\*"; DestDir: "{app}\DAQ_Analysis"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: custom; Tasks: "DAQ_Scan\DAQ_Analysis"; 
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\DAQ_Measurement\*"; DestDir: "{app}\DAQ_Measurement"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: custom; Tasks: "DAQ_Scan\DAQ_Measurement";
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\DAQ_Move\*"; DestDir: "{app}\DAQ_Move"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: custom; Tasks: "DAQ_Scan\DAQ_Move"; 
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\DAQ_Viewer\*"; DestDir: "{app}\DAQ_Viewer"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: custom; Tasks: "DAQ_Scan\DAQ_Viewer";
Source: "C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\DAQ_Metheor\*"; DestDir: "{app}\DAQ_Metheor"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: custom; Tasks: "DAQ_Metheor";   


; Lancement du script pre-install verifiant la presence de python 3 sur le pc
[Code]
function InitializeSetup(): boolean;
var
  ResultCode: integer;
begin
  Exec(ExpandConstant('C:\Users\flim-users\Documents\Tests install\Final\PyMoDAQ\DAQ_Analysis\setup\pyAsk.bat'), '', '', SW_SHOW, ewWaitUntilTerminated, ResultCode)
  Result := True;
end;


[Run]
;Definition des scripts d'installation unitaire  associer aux differents profils d'installation
; Les profils dpendent de la composante (full ou custom) et des tasks 
;(choix des modules dans le cadre d'une installation custom)

Filename: "{app}\DAQ_Analysis\setup\PyMoDAQ_dependencies-1.0.win-amd64.exe"; StatusMsg: "Building dependencies"; Flags: 64bit; Components: full; 
Filename: "{app}\DAQ_Analysis\setup\make_dep.bat"; StatusMsg: "Building dependencies"; Flags: 64bit; Components: full;   
Filename: "{app}\DAQ_Scan\setup\setup.bat"; StatusMsg: "Building module"; Flags: 64bit; Tasks: "DAQ_Scan"; Components: custom;
Filename: "{app}\DAQ_Analysis\setup\setup.bat"; StatusMsg: "Building module"; Flags: 64bit; Tasks: "DAQ_Scan\DAQ_Analysis" ; Components: custom;
Filename: "{app}\DAQ_Measurement\setup\setup.bat"; StatusMsg: "Building module"; Flags: 64bit; Tasks: "DAQ_Scan\DAQ_Measurement"; Components: custom;
Filename: "{app}\DAQ_Metheor\setup\setup.bat";  StatusMsg: "Building module"; Flags: 64bit; Tasks: "DAQ_Metheor"; Components: custom;
Filename: "{app}\DAQ_Move\setup\setup.bat"; StatusMsg: "Building module"; Flags: 64bit; Tasks:"DAQ_Scan\DAQ_Move"; Components: custom;
Filename: "{app}\DAQ_Viewer\setup\setup.bat"; StatusMsg: "Building module"; Tasks: "DAQ_Scan\DAQ_Viewer"; Components: custom;

[Icons]
; Lier les icones aux executables
; Les icones prsentes ici seront installes dans le menu demarrer de windows
Name: "{group}\DAQ Analysis"; Filename: "{app}\DAQ_Analysis\DAQ Analysis.exe"; IconFilename: "{app}/icon.ico";
Name: "{group}\DAQ Measurement"; Filename: "{app}\DAQ_Measurement\DAQ Measurement.exe"; IconFilename: "{app}/icon.ico";
Name: "{group}\DAQ Metheor"; Filename: "{app}\DAQ_Metheor\DAQ Metheor.exe"; IconFilename: "{app}/icon.ico";
Name: "{group}\DAQ Move"; Filename: "{app}\DAQ_Move\DAQ Move.exe"; IconFilename: "{app}/icon.ico";
Name: "{group}\DAQ Scan"; Filename: "{app}\DAQ_Scan\DAQScan.bat"; IconFilename: "{app}/icon.ico";
Name: "{group}\DAQ Viewer"; Filename: "{app}\DAQ_Viewer\DAQ Viewer.exe"; IconFilename: "{app}/icon.ico";
Name: "{group}\PyMoDAQ Documentation"; Filename: "{app}\Documentation\_build\html\index.html"; 
Name: "{group}\uninstall PyMoDAQ"; Filename: "{app}\unins000.exe";
Name: "{group}\{cm:ProgramOnTheWeb,{#MyAppName}}"; Filename: "{#MyAppURL}";

;Creation des raccourcis selon le profil d'installation

;Full installation shortcuts profile
; Creation des raccourcis bureau d'une installation complte
Name: "{userdesktop}\DAQ Scan"; Filename: "{app}\DAQ_Scan\DAQScan.bat"; IconFilename: "{app}/icon.ico"; Components: full;
Name: "{userdesktop}\DAQ Metheor"; Filename: "{app}\DAQ_Metheor\DAQ Metheor.exe"; IconFilename: "{app}/icon.ico"; Components: full;
Name: "{userdesktop}\DAQ Analysis"; Filename: "{app}\DAQ_Analysis\DAQ Analysis.exe"; IconFilename: "{app}/icon.ico"; Components: full;
Name: "{userdesktop}\DAQ Measurement"; Filename: "{app}\DAQ_Measurement\DAQ Measurement.exe"; IconFilename: "{app}/icon.ico"; Components: full; 
Name: "{userdesktop}\DAQ Move"; Filename: "{app}\DAQ_Move\DAQ Move.exe"; IconFilename: "{app}/icon.ico"; Components: full;
Name: "{userdesktop}\DAQ Viewer"; Filename: "{app}\DAQ_Viewer\DAQ Viewer.exe"; IconFilename: "{app}/icon.ico"; Components: full;

;Custom installation shortcuts profile
; Cration des raccourcis bureax correspondant  une installation custom
; Sous rserve d'avoir t coch par l'utilisateur.
Name: "{userdesktop}\DAQ Metheor"; Filename: "{app}\DAQ_Metheor\DAQ Metheor.exe"; IconFilename: "{app}/icon.ico";Tasks: "DAQ_Metheor"; Components: custom;
Name: "{userdesktop}\DAQ Scan"; Filename: "{app}\DAQ_Scan\DAQScan.bat"; IconFilename: "{app}/icon.ico"; Tasks: "DAQ_Scan"; Components: custom;
Name: "{userdesktop}\DAQ Analysis"; Filename: "{app}\DAQ_Analysis\DAQ Analysis.exe"; IconFilename: "{app}/icon.ico";Tasks: "DAQ_Scan\DAQ_Analysis"; Components: custom;
Name: "{userdesktop}\DAQ Measurement"; Filename: "{app}\DAQ_Measurement\DAQ Measurement.exe"; IconFilename: "{app}/icon.ico";Tasks: "DAQ_Scan\DAQ_Measurement"; Components: custom;  
Name: "{userdesktop}\DAQ Move"; Filename: "{app}\DAQ_Move\DAQ Move.exe"; IconFilename: "{app}/icon.ico";Tasks: "DAQ_Scan\DAQ_Move"; Components: custom; 
Name: "{userdesktop}\DAQ Viewer"; Filename: "{app}\DAQ_Viewer\DAQ Viewer.exe"; IconFilename: "{app}/icon.ico";Tasks: "DAQ_Scan\DAQ_Viewer"; Components: custom;

;Rajout du lien vers la documentation commun
Name: "{userdesktop}\Documentation"; Filename: "{app}\Documentation\_build\html\index.html";
